import { GameOptions } from './gameOptions';

export class LevelThumbnail extends Phaser.GameObjects.Container {
 
    private levelText: Phaser.GameObjects.Text;
    private levelSprite: Phaser.GameObjects.Sprite;
    private isPressed: boolean = false;
 
    constructor(scene: Phaser.Scene, x: number, y: number, key: string, level: number, page: number, locked: boolean) {
        
        super(scene, x, y);
        scene.add.existing(this);
      
        this.levelSprite = scene.add.sprite(0, 0, key);
        this.levelSprite.setFrame(locked ? 0 : 1);
        this.levelSprite.setTint(GameOptions.tintColors[page % GameOptions.tintColors.length]);
        this.add(this.levelSprite);
        
        this.levelText = scene.add.text(0, - 14, level.toString(), {
            font: '24px Arial',
            color: '#000000'
        });
        this.levelText.setOrigin(0.5);
        this.add(this.levelText);

        this.levelSprite.setInteractive();

        this.levelSprite.on('pointerdown', () => {
            this.isPressed = true;
        });

        this.levelSprite.on('pointerup', () => {
            if (this.isPressed) {
                this.isPressed = false;
                this.emit('levelSelected', locked, level);
            }
        });

        this.levelSprite.on('pointerout', () => {
            this.isPressed = false;
        });  
    }
}