import 'phaser';                                            // Phaser    
import { PreloadAssets }    from './scenes/preloadAssets';  // PreloadAssets scene
import { PlayGame }         from './scenes/playGame';       // PlayGame scene
import './style.css';                                       // main page stylesheet

// game configuration object
let configObject : Phaser.Types.Core.GameConfig = {
    scale : {
        mode        : Phaser.Scale.FIT,                     // set game size to fit the entire screen
        autoCenter  : Phaser.Scale.CENTER_BOTH,             // center the canvas both horizontally and vertically in the parent div
        parent      : 'thegame',                            // parent div element
        width       : 640,                                  // game width, in pixels
        height      : 480,                                  // game height, in pixels
    },
    backgroundColor : 0x444444,                             // game background color
    scene           : [  
        PreloadAssets,                                      // scene to preload all game assets
        PlayGame                                            // the game itself
    ]
};
 
new Phaser.Game(configObject);