import { GameOptions } from './gameOptions';
 
export class PageSelector extends Phaser.GameObjects.Sprite {
 
    private pageIndex: number;
    private isPressed: boolean = false;
 
    constructor(scene: Phaser.Scene, x: number, y: number, key: string, pageIndex: number, current: number) {
 
        super(scene, x, y, key);
       
        this.pageIndex = pageIndex;
        scene.add.existing(this);
        
        this.setTint(GameOptions.tintColors[pageIndex % GameOptions.tintColors.length]);
        this.setFrame(pageIndex === current ? 1 : 0);

        this.updateThumb(current);

        this.setInteractive();
            
        this.on('pointerdown', () => {
            this.isPressed = true;
        });

        this.on('pointerup', () => {
            if (this.isPressed) {
                this.isPressed = false;
                this.emit('pageSelected', pageIndex);
            }
        });

        this.on('pointerout', () => {
            this.isPressed = false;
        });
    }

    updateThumb(n: number): void {
        this.setFrame(this.pageIndex === n ? 1 : 0);
    }
}