// CLASS TO PRELOAD ASSETS

// PreloadAssets class extends Phaser.Scene class
export class PreloadAssets extends Phaser.Scene {
  
    // constructor    
    constructor() {
        super({
            key : 'PreloadAssets'
        });
    }
  
    // method to be called during class preloading
    preload() : void {
        this.load.spritesheet('levelthumb', 'assets/sprites/levelthumb.png', {
            frameWidth : 60,
            frameHeight : 60
        });

        this.load.spritesheet('levelpages', 'assets/sprites/levelpages.png', {
            frameWidth: 30,
            frameHeight: 30
        });

        this.load.image('transp', 'assets/sprites/transp.png');
    }
  
    // method to be executed when the scene is created
    create() : void {

        // start PlayGame scene
        this.scene.start('PlayGame');
    }
}